/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.principal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A {@link SimplePrincipalAttribute} holding a String value.
 */
public class StringPrincipalAttribute extends SimplePrincipalAttribute<String>
{
    /**
     * Creates an {@link PrincipalAttribute} containing a String value.
     * 
     * @param name
     *            The name of this UserAttribute.
     * @param value
     *            The value of this attribute.
     */
    public StringPrincipalAttribute( @Nonnull final String name, @Nullable final String value )
    {
        super(name, value);
    }
}
