/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalFacade;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.Executable;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.exception.ThreadContextExecutionException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrincipalAccessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrincipalAccessor.class);
    @Nonnull
    private static Try<PrincipalFacade> principalFacade = FacadeLocator.getFacade(PrincipalFacade.class);
    @Nullable
    private static Supplier<Principal> fallbackPrincipal = null;

    @Nullable
    public static PrincipalFacade getPrincipalFacade() {
        return (PrincipalFacade)principalFacade.getOrNull();
    }

    @Nonnull
    public static Try<PrincipalFacade> tryGetPrincipalFacade() {
        return principalFacade;
    }

    public static void setPrincipalFacade(@Nullable PrincipalFacade principalFacade) {
        PrincipalAccessor.principalFacade = principalFacade == null ? FacadeLocator.getFacade(PrincipalFacade.class) : Try.success((Object)principalFacade);
    }

    @Nonnull
    public static Principal getCurrentPrincipal() throws PrincipalAccessException {
        return (Principal)PrincipalAccessor.tryGetCurrentPrincipal().getOrElseThrow(failure -> {
            if (failure instanceof PrincipalAccessException) {
                throw (PrincipalAccessException)failure;
            }
            throw new PrincipalAccessException("Failed to get current principal.", (Throwable)failure);
        });
    }

    @Nonnull
    public static Try<Principal> tryGetCurrentPrincipal() {
        Try principalTry = principalFacade.flatMap(PrincipalFacade::tryGetCurrentPrincipal);
        if (principalTry.isSuccess() || fallbackPrincipal == null) {
            return principalTry;
        }
        Principal fallback = fallbackPrincipal.get();
        if (fallback == null) {
            return Try.failure((Throwable)new PrincipalAccessException());
        }
        return principalTry.recover(failure -> {
            log.warn("Recovering with fallback principal: {}.", (Object)fallback, failure);
            return fallback;
        });
    }

    @Nullable
    public static <T> T executeWithPrincipal(@Nonnull Principal principal, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        return (T)((ThreadContextExecutor)((ThreadContextExecutor)new ThreadContextExecutor().withThreadContext((ThreadContext)new DefaultThreadContext())).withListeners(new ThreadContextListener[]{new PrincipalThreadContextListener(principal)})).execute(callable);
    }

    public static void executeWithPrincipal(@Nonnull Principal principal, @Nonnull Executable executable) throws ThreadContextExecutionException {
        PrincipalAccessor.executeWithPrincipal(principal, () -> {
            executable.execute();
            return null;
        });
    }

    @Nullable
    public static <T> T executeWithFallbackPrincipal(@Nonnull Supplier<Principal> fallbackPrincipal, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        Try<Principal> principalTry = PrincipalAccessor.tryGetCurrentPrincipal();
        if (principalTry.isSuccess()) {
            try {
                return callable.call();
            }
            catch (ThreadContextExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ThreadContextExecutionException((Throwable)e);
            }
        }
        return PrincipalAccessor.executeWithPrincipal(fallbackPrincipal.get(), callable);
    }

    public static void executeWithFallbackPrincipal(@Nonnull Supplier<Principal> fallbackPrincipal, @Nonnull Executable executable) throws ThreadContextExecutionException {
        PrincipalAccessor.executeWithFallbackPrincipal(fallbackPrincipal, () -> {
            executable.execute();
            return null;
        });
    }

    @Generated
    private PrincipalAccessor() {
    }

    @Nullable
    @Generated
    public static Supplier<Principal> getFallbackPrincipal() {
        return fallbackPrincipal;
    }

    @Generated
    public static void setFallbackPrincipal(@Nullable Supplier<Principal> fallbackPrincipal) {
        PrincipalAccessor.fallbackPrincipal = fallbackPrincipal;
    }
}

