/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.result;

import com.sap.cloud.sdk.result.ObjectExtractor;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.result.ResultPrimitive;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimitiveBasedObjectExtractor<T>
implements ObjectExtractor<T> {
    private static final Logger log = LoggerFactory.getLogger(PrimitiveBasedObjectExtractor.class);
    private final Class<T> objectType;

    @Override
    @Nonnull
    public T extract(@Nonnull ResultElement resultElement) {
        if (!(resultElement instanceof ResultPrimitive)) {
            throw new UnsupportedOperationException("Failed to instantiate " + this.objectType.getName() + " with non-primitive value " + resultElement + ".");
        }
        try {
            SingleParameterConstructor construction = null;
            for (Constructor<?> constructor : this.objectType.getDeclaredConstructors()) {
                Object parameterValue;
                Class<?>[] parameters = constructor.getParameterTypes();
                if (parameters.length != 1 || (parameterValue = this.getParameterValue(resultElement, parameters[0])) == null || construction != null && !parameters[0].isPrimitive()) continue;
                try {
                    constructor.setAccessible(true);
                    construction = new SingleParameterConstructor(constructor, parameterValue);
                }
                catch (SecurityException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Constructor for " + this.objectType.getName() + " with " + parameters[0].getSimpleName() + " parameter is not accessible. Please check the active Java Security Manager.", (Throwable)e);
                }
            }
            if (construction != null) {
                return this.objectType.cast(construction.getConstructor().newInstance(construction.getParameterValue()));
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to instantiate " + this.objectType.getName() + " with constructor by value " + resultElement + " - " + e.getMessage() + ".", e);
        }
        throw new UnsupportedOperationException("Unsupported constructor of " + this.objectType.getName() + " to value " + resultElement + ".");
    }

    @Nullable
    private Object getParameterValue(ResultElement resultElement, Class<?> parameter) {
        if (parameter.isAssignableFrom(String.class)) {
            return resultElement.asString();
        }
        if (parameter.isAssignableFrom(BigDecimal.class)) {
            return resultElement.asBigDecimal();
        }
        if (parameter.isAssignableFrom(BigInteger.class)) {
            return resultElement.asBigInteger();
        }
        if (parameter == Character.TYPE || parameter.isAssignableFrom(Character.class)) {
            return Character.valueOf(resultElement.asCharacter());
        }
        if (parameter == Double.TYPE || parameter.isAssignableFrom(Double.class)) {
            return resultElement.asDouble();
        }
        if (parameter == Float.TYPE || parameter.isAssignableFrom(Float.class)) {
            return Float.valueOf(resultElement.asFloat());
        }
        if (parameter == Long.TYPE || parameter.isAssignableFrom(Long.class)) {
            return resultElement.asLong();
        }
        if (parameter == Integer.TYPE || parameter.isAssignableFrom(Integer.class)) {
            return resultElement.asInteger();
        }
        if (parameter == Short.TYPE || parameter.isAssignableFrom(Short.class)) {
            return resultElement.asShort();
        }
        if (parameter == Byte.TYPE || parameter.isAssignableFrom(Byte.class)) {
            return resultElement.asByte();
        }
        if (parameter == Boolean.TYPE || parameter.isAssignableFrom(Boolean.class)) {
            return resultElement.asBoolean();
        }
        return null;
    }

    public PrimitiveBasedObjectExtractor(Class<T> objectType) {
        this.objectType = objectType;
    }

    private static class SingleParameterConstructor {
        private final Constructor<?> constructor;
        private final Object parameterValue;

        public SingleParameterConstructor(Constructor<?> constructor, Object parameterValue) {
            this.constructor = constructor;
            this.parameterValue = parameterValue;
        }

        public Constructor<?> getConstructor() {
            return this.constructor;
        }

        public Object getParameterValue() {
            return this.parameterValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleParameterConstructor)) {
                return false;
            }
            SingleParameterConstructor other = (SingleParameterConstructor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Constructor<?> this$constructor = this.getConstructor();
            Constructor<?> other$constructor = other.getConstructor();
            if (this$constructor == null ? other$constructor != null : !((Object)this$constructor).equals(other$constructor)) {
                return false;
            }
            Object this$parameterValue = this.getParameterValue();
            Object other$parameterValue = other.getParameterValue();
            return !(this$parameterValue == null ? other$parameterValue != null : !this$parameterValue.equals(other$parameterValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SingleParameterConstructor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Constructor<?> $constructor = this.getConstructor();
            result = result * 59 + ($constructor == null ? 43 : ((Object)$constructor).hashCode());
            Object $parameterValue = this.getParameterValue();
            result = result * 59 + ($parameterValue == null ? 43 : $parameterValue.hashCode());
            return result;
        }

        public String toString() {
            return "PrimitiveBasedObjectExtractor.SingleParameterConstructor(constructor=" + this.getConstructor() + ", parameterValue=" + this.getParameterValue() + ")";
        }
    }
}

