/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes;
import com.sap.cloud.sdk.service.prov.api.filter.NodeInfo;
import com.sap.cloud.sdk.service.prov.api.filter.exception.FilterOptionException;

public class NodeInfoImpl
implements NodeInfo {
    private String nodeOperator;
    private ExpressionOperatorTypes.NODE_KIND nodeKind;
    private boolean customNode = false;

    public NodeInfoImpl(String nodeOperator, ExpressionOperatorTypes.NODE_KIND kind) {
        this.nodeOperator = nodeOperator;
        this.nodeKind = kind;
    }

    public NodeInfoImpl(ExpressionOperatorTypes.NODE_KIND kind) throws FilterOptionException {
        if (kind != ExpressionOperatorTypes.NODE_KIND.LITERAL && kind != ExpressionOperatorTypes.NODE_KIND.PROPERTY) {
            throw new FilterOptionException("Only Literal and Simple Property types are supported without Node Operator in Filter Expression Tree");
        }
        this.nodeOperator = "";
        this.nodeKind = kind;
    }

    @Override
    public String getNodeOperator() {
        return this.nodeOperator;
    }

    public ExpressionOperatorTypes.NODE_KIND getNodeKind() {
        return this.nodeKind;
    }

    public void setCustomNode(boolean customNode) {
        this.customNode = customNode;
    }

    public boolean isCustomNode() {
        return this.customNode;
    }
}

