/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.response.impl;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.response.QueryResponse;
import com.sap.cloud.sdk.service.prov.api.response.QueryResponseBuilder;
import com.sap.cloud.sdk.service.prov.api.response.impl.QueryResponseImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResponseBuilderImpl
implements QueryResponseBuilder {
    private static Logger log = LoggerFactory.getLogger(QueryResponseBuilderImpl.class);
    private List<?> data;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private boolean enable = false;
    private EntityData auditEntityData;
    private List<String> auditProps;
    private boolean isTopDone;
    private boolean isSkipDone;
    private int inlineCount = -1;

    @Override
    public QueryResponseBuilder setDataAsMap(List<Map<String, Object>> data) {
        this.data = data;
        return this;
    }

    @Override
    public QueryResponseBuilder setEntityData(List<EntityData> data) {
        this.data = data;
        return this;
    }

    @Override
    public QueryResponseBuilder setData(List<?> data) {
        this.data = data;
        return this;
    }

    @Override
    public QueryResponseBuilder addHeaders(Map<String, List<String>> headers) {
        if (headers != null && !headers.isEmpty()) {
            if (this.headers.isEmpty()) {
                this.headers.putAll(headers);
            } else {
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                    String headerName = this.getHeaderName(entry.getKey());
                    if (this.headers.get(headerName) == null) {
                        this.headers.put(headerName, new ArrayList(entry.getValue()));
                        continue;
                    }
                    this.headers.get(headerName).addAll((Collection<String>)entry.getValue());
                }
            }
        }
        return this;
    }

    @Override
    public QueryResponseBuilder setHeader(String name, String value) {
        String headerName = this.getHeaderName(name);
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(value);
        if (log.isDebugEnabled()) {
            log.debug("Set header name " + name + " with value " + value + ".");
        }
        this.headers.put(headerName, valueList);
        return this;
    }

    @Override
    public QueryResponseBuilder addHeader(String name, String value) {
        String headerName = this.getHeaderName(name);
        List<String> valueList = this.headers.get(headerName);
        if (valueList == null) {
            valueList = new ArrayList<String>();
        }
        valueList.add(value);
        if (log.isDebugEnabled()) {
            log.debug("Replace header name " + name + ". Setting name " + headerName + " with value " + value + ".");
        }
        this.headers.put(headerName, valueList);
        return this;
    }

    @Override
    public QueryResponse response() {
        QueryResponseImpl queryResponse = new QueryResponseImpl();
        queryResponse.setData(this.data);
        queryResponse.setHeaders(this.headers);
        queryResponse.setSkipDone(this.isSkipDone);
        queryResponse.setTopDone(this.isTopDone);
        queryResponse.setInlineCount(this.inlineCount);
        queryResponse.audit(this.enable);
        queryResponse.audit(this.auditEntityData, this.auditProps);
        return queryResponse;
    }

    @Override
    @Deprecated
    public QueryResponseBuilder audit(boolean enable) {
        this.enable = enable;
        return this;
    }

    @Override
    @Deprecated
    public QueryResponseBuilder audit(EntityData auditEntityData, List<String> properties) {
        this.auditEntityData = auditEntityData;
        this.auditProps = properties;
        return this;
    }

    @Override
    public QueryResponseBuilder setTopDone(boolean isTopDone) {
        this.isTopDone = isTopDone;
        return this;
    }

    @Override
    public QueryResponseBuilder setSkipDone(boolean isSkipDone) {
        this.isSkipDone = isSkipDone;
        return this;
    }

    protected String getHeaderName(String name) {
        if (name == null || "".equals(name.trim()) || this.headers == null) {
            return name;
        }
        for (String headerName : this.headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return headerName;
        }
        return name;
    }

    @Override
    public QueryResponseBuilder setInlineCount(int inlineCount) {
        this.inlineCount = inlineCount;
        return this;
    }
}

