/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTUtil {
    private static final Logger log = LoggerFactory.getLogger(JWTUtil.class);
    private static final String SYSTEM_ATTRIBUTES = "xs.system.attributes";
    private static final String USER_ATTRIBUTES = "xs.user.attributes";
    private static final String GRANT_TYPE = "grant_type";

    public static JsonElement getValueFromJwt(String attributeName) {
        JsonObject temp;
        log.debug("Reading value of the attibute '{}' from JWT.", (Object)attributeName);
        JsonElement attributeValueElement = null;
        if (AuthorizationService.getJWTToken() == null) {
            return null;
        }
        JsonObject attributes = AuthorizationService.getJWTToken().getJwtAsJsonNode();
        if (null != attributes) {
            attributeValueElement = attributes.get(attributeName);
        }
        if (attributeValueElement == null && attributes != null && null != (temp = attributes.getAsJsonObject(SYSTEM_ATTRIBUTES))) {
            attributeValueElement = temp.get(attributeName);
        }
        if (attributeValueElement == null && attributes != null && null != (temp = attributes.getAsJsonObject(USER_ATTRIBUTES))) {
            attributeValueElement = temp.get(attributeName);
        }
        return attributeValueElement;
    }

    public static List<String> getScopes() {
        log.debug("Reading all scopes of the current user from JWT");
        ArrayList<String> lstScopes = new ArrayList<String>();
        JsonElement scopes = JWTUtil.getValueFromJwt("scope");
        if (null != scopes && scopes.isJsonArray()) {
            Iterator scopeIterator = scopes.getAsJsonArray().iterator();
            while (scopeIterator.hasNext()) {
                String curScope = JWTUtil.getScopeName(((JsonElement)scopeIterator.next()).getAsString());
                lstScopes.add(curScope);
            }
        }
        return lstScopes;
    }

    private static String getScopeName(String fullScopeName) {
        String[] actualScopeDetails = fullScopeName.split("\\.", 2);
        int size = actualScopeDetails.length - 1;
        return actualScopeDetails[size].trim();
    }

    public static String getGrantType() {
        log.debug("Reading agrant type from JWT");
        String grantType = null;
        JsonElement grantElement = JWTUtil.getValueFromJwt(GRANT_TYPE);
        if (grantElement != null) {
            grantType = grantElement.getAsString();
        }
        return grantType;
    }

    public static String getJWTAttribute(String attributeName) {
        log.debug("Reading all value of {} from JWT", (Object)attributeName);
        String attributeValue = "";
        JsonElement attributeValueElement = JWTUtil.getValueFromJwt(attributeName);
        if (null != attributeValueElement && attributeValueElement.isJsonPrimitive()) {
            attributeValue = attributeValueElement.getAsString();
        } else if (null != attributeValueElement && attributeValueElement.isJsonArray()) {
            JsonArray attributes = attributeValueElement.getAsJsonArray();
            if (attributes.size() == 1) {
                attributeValue = attributeValueElement.getAsJsonArray().get(0).getAsString();
            } else {
                for (int i = 0; i < attributes.size(); ++i) {
                    attributeValue = attributeValue + attributeValueElement.getAsJsonArray().get(i).getAsString();
                    if (i == attributes.size() - 1) continue;
                    attributeValue = attributeValue + ",";
                }
            }
        }
        return attributeValue;
    }
}

