/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.transaction.impl;

import com.sap.cloud.sdk.service.prov.api.exception.TransactionException;
import com.sap.cloud.sdk.service.prov.api.transaction.TransactionManager;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandler {
    private static ThreadLocal<ArrayList<TransactionManager>> transactionManagers = new ThreadLocal<ArrayList<TransactionManager>>(){

        @Override
        protected ArrayList<TransactionManager> initialValue() {
            return new ArrayList<TransactionManager>();
        }
    };
    static final Logger logger = LoggerFactory.getLogger(TransactionHandler.class);
    private static ThreadLocal<Boolean> isChangeSet = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Boolean> isStarted = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static void addTransactionManager(TransactionManager transactionManager) {
        transactionManagers.get().add(transactionManager);
    }

    public static Boolean isInitialized() {
        return transactionManagers.get().size() != 0;
    }

    public static void startChangeSetTransaction() {
        TransactionHandler.startTransaction();
        isChangeSet.set(true);
    }

    public static void endChangeSetTransaction() {
        isChangeSet.set(false);
    }

    public static void startTransaction() {
        if (isChangeSet.get().booleanValue()) {
            return;
        }
        if (isStarted.get().booleanValue()) {
            TransactionHandler.commitTransaction();
        }
        isStarted.set(true);
        for (TransactionManager transactionManager : transactionManagers.get()) {
            try {
                transactionManager.startTransaction();
            }
            catch (TransactionException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void commitTransaction() {
        if (isChangeSet.get().booleanValue()) {
            return;
        }
        isStarted.set(false);
        for (TransactionManager transactionManager : transactionManagers.get()) {
            try {
                transactionManager.commitTransaction();
            }
            catch (TransactionException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void rollbackTransaction() {
        isStarted.set(false);
        for (TransactionManager transactionManager : transactionManagers.get()) {
            try {
                transactionManager.rollbackTransaction();
            }
            catch (TransactionException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void cleanupTransaction() {
        isStarted.set(false);
        if (isChangeSet.get().booleanValue()) {
            return;
        }
        for (TransactionManager transactionManager : transactionManagers.get()) {
            transactionManager.cleanupTransaction();
        }
        transactionManagers.get().clear();
    }

    public static boolean isActive() {
        return isStarted.get();
    }
}

