/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassHelper {
    private static final String JAR_FILE_ENDING = "jar";
    private static final char RESOURCE_SEPARATOR = '/';
    private static final char PACKAGE_SEPARATOR = '.';
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final String CLASSFILE_ENDING = ".class";
    private static final FilenameFilter CLASSFILE_FILTER = (dir, name) -> name.endsWith(CLASSFILE_ENDING);
    private static final FileFilter FOLDER_FILTER = File::isDirectory;
    static final Logger logger = LoggerFactory.getLogger(ClassHelper.class);

    public static List<Class<?>> loadClassesFromClasspath(ClassValidator cv) {
        try {
            return ClassHelper.loadClasses("", cv);
        }
        catch (Exception e) {
            logger.error("loading classes from classpath error", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static List<Class<?>> loadClasses(String packageToScan, ClassValidator cv) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        List<Object> urls = new ArrayList();
        if (packageToScan == null) {
            if (classloader instanceof URLClassLoader) {
                urls = Arrays.asList(((URLClassLoader)classloader).getURLs());
            }
        } else {
            Enumeration<URL> urlEnumeration;
            try {
                urlEnumeration = classloader.getResources(packageToScan.replace('.', '/'));
            }
            catch (IOException e) {
                logger.error("Error while scanning the classpath", (Throwable)e);
                throw new RuntimeException("Error while scanning the classpath", e);
            }
            while (urlEnumeration.hasMoreElements()) {
                urls.add(urlEnumeration.nextElement());
            }
        }
        ArrayList fqnForClasses = new ArrayList();
        urls.parallelStream().forEach(url -> {
            String protocol = url.getProtocol();
            if (protocol.equals(JAR_FILE_ENDING)) {
                URI uri = null;
                try {
                    uri = url.toURI();
                }
                catch (URISyntaxException e) {
                    logger.error("Error while reading jar.", (Throwable)e);
                    return;
                }
                String filepath = uri.getSchemeSpecificPart().substring(5);
                String[] split = filepath.split("!");
                String jarFilePath = split[0];
                fqnForClasses.addAll(ClassHelper.getClassFqnsFromJar(new File(jarFilePath), packageToScan));
            } else if (protocol.equals("file")) {
                File resource = new File(url.getPath());
                if (resource.isDirectory()) {
                    fqnForClasses.addAll(ClassHelper.getClassFqnFromDir(CLASSFILE_FILTER, resource, packageToScan));
                } else if (resource.getName().endsWith(CLASSFILE_ENDING)) {
                    fqnForClasses.add(resource.getName().substring(0, resource.getName().length() - CLASSFILE_ENDING.length()));
                } else if (resource.getName().endsWith(".jar")) {
                    fqnForClasses.addAll(ClassHelper.getClassFqnsFromJar(resource, packageToScan));
                }
            }
        });
        List<Class<?>> validClasses = fqnForClasses.parallelStream().map(c -> {
            try {
                return classloader.loadClass((String)c);
            }
            catch (Throwable t) {
                if (t instanceof VirtualMachineError) {
                    throw (VirtualMachineError)t;
                }
                logger.debug("Error while loading class " + c, t);
                return null;
            }
        }).filter(c -> {
            if (c == null) {
                return false;
            }
            return cv.isClassValid((Class<?>)c);
        }).collect(Collectors.toList());
        return validClasses;
    }

    private static List<String> getClassFqnsFromJar(File resource, String packageToScan) {
        ArrayList<String> classes = new ArrayList<String>();
        try (JarFile jar = new JarFile(resource);){
            packageToScan = packageToScan != null && !packageToScan.equals("") ? packageToScan.replace('.', '/') : null;
            if (jar != null) {
                Enumeration<JarEntry> jarEntries = jar.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry entry = jarEntries.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || !(packageToScan == null ? !ClassHelper.isPackageExcluded(name) : name.startsWith(packageToScan)) || !name.endsWith(CLASSFILE_ENDING)) continue;
                    classes.add(name.substring(0, name.length() - CLASSFILE_ENDING.length()).replaceAll("/", "."));
                }
            }
        }
        catch (IOException e) {
            logger.error("Error while reading a jar file", (Throwable)e);
        }
        return classes;
    }

    private static boolean isPackageExcluded(String name) {
        List<String> excludedPackages = Arrays.asList("org", "com/sap/cloud/sdk", "com/sap/cloud/servicesdk", "javax", "com/sap/it/commons", "com/sap/gateway/core", "javassist", "com/netflix", "rx", "com/auth0", "com/ctc/wstx", "com/google", "com/ibm", "com/microsoft");
        for (String pkg : excludedPackages) {
            if (!name.startsWith(pkg + "/")) continue;
            return true;
        }
        return false;
    }

    private static Collection<String> getClassFqnFromDir(FilenameFilter ff, File folder, String packageToScan) {
        File[] subfolders;
        String[] classFilesForFolder;
        ArrayList<String> classFiles = new ArrayList<String>();
        String packagePrefix = "";
        if (packageToScan != null && !packageToScan.isEmpty()) {
            packagePrefix = packageToScan + ".";
        }
        for (String name : classFilesForFolder = folder.list(ff)) {
            String fqn = packagePrefix + name.substring(0, name.length() - CLASSFILE_ENDING.length());
            classFiles.add(fqn);
        }
        for (File file : subfolders = ClassHelper.listSubFolder(folder)) {
            classFiles.addAll(ClassHelper.getClassFqnFromDir(ff, file, packagePrefix + file.getName()));
        }
        return classFiles;
    }

    private static File[] listSubFolder(File folder) {
        File[] subfolders = folder.listFiles(FOLDER_FILTER);
        if (subfolders == null) {
            return EMPTY_FILE_ARRAY;
        }
        return subfolders;
    }

    public static interface ClassValidator {
        public boolean isClassValid(Class<?> var1);
    }
}

