/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.util;

import com.sap.cloud.sdk.service.prov.api.connection.DataSourceParams;
import com.sap.cloud.sdk.service.prov.api.usercontext.UserContextParams;
import com.sap.cloud.sdk.service.prov.rt.datasource.factory.DatasourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessingHelper {
    private static DataSourceParams connectionProvider = null;
    private static UserContextParams userContextProvider;
    private static DatasourceType datasourceProvider;
    static final Logger logger;

    public static void setConnectionProviderClass(String connection) {
        try {
            connectionProvider = (DataSourceParams)Class.forName(connection).newInstance();
        }
        catch (Exception e) {
            logger.error("Error while initializing connection class " + connection, (Throwable)e);
        }
    }

    public static void setConnectionProvider(DataSourceParams dsParams) {
        connectionProvider = dsParams;
    }

    public static void setUserContextProvider(String ucParamsClass) {
        try {
            userContextProvider = (UserContextParams)Class.forName(ucParamsClass).newInstance();
        }
        catch (Exception e) {
            logger.error("Error while initializing connection class " + ucParamsClass, (Throwable)e);
        }
    }

    public static UserContextParams getUserContextProvider() {
        return userContextProvider;
    }

    public static DataSourceParams getConnectionProvider() {
        return connectionProvider;
    }

    public static void setDatasourceProvider(String datasourceType) {
        switch (datasourceType) {
            case "HANA": {
                datasourceProvider = DatasourceType.HANA;
                break;
            }
            case "CDS": {
                datasourceProvider = DatasourceType.CDS;
            }
        }
    }

    public static DatasourceType getDatasourceProvider() {
        return datasourceProvider;
    }

    static {
        datasourceProvider = DatasourceType.CDS;
        logger = LoggerFactory.getLogger(RequestProcessingHelper.class);
    }
}

