/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.connection;

import com.sap.cloud.sdk.service.prov.api.connection.DataSourceParams;
import com.sap.cloud.sdk.service.prov.api.connection.HashedData;
import com.sap.cloud.sdk.service.prov.api.connection.JDBCDataSourceParams;
import com.sap.cloud.sdk.service.prov.api.transaction.impl.TransactionHandler;
import com.sap.cloud.sdk.service.prov.api.util.RequestProcessingHelper;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.time.Instant;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class ThreadSafeObjectStore
implements ServletRequestListener {
    static final Logger logger = LoggerFactory.getLogger(ThreadSafeObjectStore.class);
    static ThreadLocal<Connection> connectionForThread = new ThreadLocal();
    static ThreadLocal<Instant> metadataLastModifiedTime = new ThreadLocal();
    static ThreadLocal<Connection> connectionForCDSHandlerFactory = new ThreadLocal();
    static ThreadLocal<HashedData> csnForThread = new ThreadLocal();
    static ThreadLocal<ByteArrayOutputStream> metadataForThread = new ThreadLocal();
    private static ThreadLocal<String> tenantIdForExtensibility = new ThreadLocal();

    public static Connection getConnection() {
        try {
            if (connectionForThread.get() == null || connectionForThread.get().isClosed()) {
                ThreadSafeObjectStore.initializeConnection();
            }
        }
        catch (Exception e) {
            logger.error("error getting connection from provider", (Throwable)e);
        }
        return connectionForThread.get();
    }

    private static void initializeConnection() {
        DataSourceParams connectionProvider = RequestProcessingHelper.getConnectionProvider();
        if (connectionProvider != null && connectionProvider instanceof JDBCDataSourceParams) {
            connectionForThread.set(((JDBCDataSourceParams)connectionProvider).getConnection());
        }
    }

    public static Connection getConnectionForCDSHandlerFactory() {
        try {
            DataSourceParams connectionProvider;
            if ((connectionForCDSHandlerFactory.get() == null || connectionForCDSHandlerFactory.get().isClosed()) && (connectionProvider = RequestProcessingHelper.getConnectionProvider()) != null && connectionProvider instanceof JDBCDataSourceParams) {
                connectionForCDSHandlerFactory.set(((JDBCDataSourceParams)connectionProvider).getConnection());
            }
        }
        catch (Exception e) {
            logger.error("error getting connection from provider", (Throwable)e);
        }
        return connectionForCDSHandlerFactory.get();
    }

    public static void setCsnForCurrentThread(HashedData csn) {
        csnForThread.set(csn);
        logger.debug("Csn is being set for the current thread.");
    }

    public static HashedData getCsnForCurrentThread() {
        return csnForThread.get();
    }

    public static Instant getMetadataLastModifiedTime() {
        return metadataLastModifiedTime.get();
    }

    public static void setMetadataLastModifiedTime(Instant metadataLastModified) {
        metadataLastModifiedTime.set(metadataLastModified);
    }

    public static ByteArrayOutputStream getMetadataForCurrentThread() {
        return metadataForThread.get();
    }

    public static void setMetadataForCurrentThread(ByteArrayOutputStream baos) {
        metadataForThread.set(baos);
    }

    public static String getTenantIdForExtensibility() {
        return tenantIdForExtensibility.get();
    }

    public static void setTenantIdForExtensibility(String tenantId) {
        tenantIdForExtensibility.set(tenantId);
    }

    private static void removeConnectionForCurrentThread() {
        if (connectionForCDSHandlerFactory.get() != null) {
            Connection conn = connectionForCDSHandlerFactory.get();
            try {
                if (!conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                logger.error("Error while closing connection", (Throwable)e);
            }
            connectionForCDSHandlerFactory.remove();
        }
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        if (connectionForThread.get() != null) {
            TransactionHandler.cleanupTransaction();
        }
        ThreadSafeObjectStore.removeConnectionForCurrentThread();
        connectionForThread.remove();
        csnForThread.remove();
        metadataForThread.remove();
        metadataLastModifiedTime.remove();
        tenantIdForExtensibility.remove();
    }

    public void requestInitialized(ServletRequestEvent sre) {
    }
}

