/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.response.impl;

import com.sap.cloud.sdk.service.prov.api.Message;
import com.sap.cloud.sdk.service.prov.api.Severity;
import com.sap.cloud.sdk.service.prov.api.request.MessageContainerImpl;
import com.sap.cloud.sdk.service.prov.api.response.ErrorResponse;
import com.sap.cloud.sdk.service.prov.api.response.ErrorResponseBuilder;
import com.sap.cloud.sdk.service.prov.api.response.impl.ErrorResponseImpl;
import java.util.ArrayList;
import java.util.List;

public class ErrorResponseBuilderImpl
implements ErrorResponseBuilder {
    boolean addMessagesFromContainer = false;
    private Severity[] allSeverities = new Severity[]{Severity.ERROR, Severity.INFO, Severity.WARNING, Severity.SUCCESS};
    List<Object> errorDetails = new ArrayList<Object>();
    private int statuscode;
    private String errorCode;
    private String message;
    private Throwable throwable;
    private boolean isErrorCodeSet = false;

    @Override
    public ErrorResponseBuilder setCause(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    @Override
    public ErrorResponseBuilder setStatusCode(int statusCode) {
        this.statuscode = statusCode;
        return this;
    }

    @Override
    public ErrorResponseBuilder setMessage(String messageKey, Object ... params) {
        if (!this.isErrorCodeSet) {
            this.errorCode = messageKey;
        }
        this.message = MessageContainerImpl.getLocalizedMessage(messageKey, params);
        return this;
    }

    public Throwable getCause() {
        return this.throwable;
    }

    public int getStatuscode() {
        return this.statuscode;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public ErrorResponse response() {
        return new ErrorResponseImpl(this.statuscode, this.errorCode, this.message, this.throwable, this.errorDetails);
    }

    @Override
    public ErrorResponseBuilder addContainerMessages(Severity ... severities) {
        if (severities == null || severities.length == 0) {
            severities = this.allSeverities;
        }
        this.errorDetails.add(severities);
        return this;
    }

    @Override
    public ErrorResponseBuilder addErrorDetail(String code, String target, Object ... params) {
        this.errorDetails.add(new Message(code, MessageContainerImpl.getLocalizedMessage(code, params), target, Severity.ERROR));
        return this;
    }

    @Override
    public ErrorResponseBuilder setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        this.isErrorCodeSet = true;
        return this;
    }
}

