/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.google.gson.JsonObject;
import com.sap.cloud.sdk.service.prov.api.security.AuthJWTToken;
import com.sap.cloud.sdk.service.prov.api.security.Authorization;
import com.sap.cloud.sdk.service.prov.api.security.BackwardCompatibility;
import com.sap.cloud.sdk.service.prov.api.security.ContainerSecurityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthorizationService {
    static final Logger logger = LoggerFactory.getLogger(AuthorizationService.class);
    private static final Logger log = LoggerFactory.getLogger(AuthorizationService.class);
    private static final String BASE_AUTH_CLASS = "com.sap.cloud.sdk.service.prov.rt.security.SpringSecurityImpl";
    private static final InheritableThreadLocal<AuthJWTToken> jwtTokenStore = new InheritableThreadLocal();
    private static final InheritableThreadLocal<Authorization> authorizationFactory = new InheritableThreadLocal();
    private static final InheritableThreadLocal<Object> userInfoStore = new InheritableThreadLocal();
    private static final String USER_INFO_CLASS = "com.sap.xs2.security.container.UserInfo";
    private static boolean isContainerSecurityEnabled = true;

    private AuthorizationService() {
    }

    public static Authorization getAuthorization() {
        Authorization auth = (Authorization)authorizationFactory.get();
        if (null == auth) {
            log.debug("Authorization object is not available. Creating a new one.");
            if (!isContainerSecurityEnabled) {
                log.info("Enabling Spring Security as container security is disbled.");
                auth = AuthorizationService.getSpringAuthObject(BASE_AUTH_CLASS);
            } else {
                log.info("Enabling container security.");
                auth = AuthorizationService.getContainerAuthObject();
            }
            if (null != auth) {
                authorizationFactory.set(auth);
            } else {
                log.error("Unable to instantiate Authorization object.");
            }
        }
        return auth;
    }

    private static Authorization getSpringAuthObject(String baseClass) {
        BackwardCompatibility auth = null;
        try {
            Authorization bc = (Authorization)Class.forName(baseClass).newInstance();
            auth = new BackwardCompatibility(bc);
        }
        catch (Exception e) {
            log.error(String.format("Error while creating an Authorization object: %s", e.getMessage()), (Throwable)e);
            auth = null;
        }
        return auth;
    }

    private static Authorization getContainerAuthObject() {
        BackwardCompatibility auth = null;
        try {
            ContainerSecurityImpl bc = new ContainerSecurityImpl();
            auth = new BackwardCompatibility(bc);
        }
        catch (Exception e) {
            log.error(String.format("Error while creating an Authorization object: %s", e.getMessage()), (Throwable)e);
            auth = null;
        }
        return auth;
    }

    public static boolean isAuthenticatedUser(String serviceName) {
        log.debug("Authorization check on service {}.", (Object)serviceName);
        Authorization auth = AuthorizationService.getAuthorization();
        if (null != auth) {
            return auth.isAuthenticatedUser(serviceName);
        }
        return false;
    }

    public static boolean isRegisteredUser(String serviceName) {
        log.debug("Registerd user check on service {}.", (Object)serviceName);
        Authorization auth = AuthorizationService.getAuthorization();
        if (null != auth) {
            return auth.isRegisteredUser(serviceName);
        }
        return false;
    }

    public static boolean hasEntityAccess(String entityName, String operation) {
        log.debug("Access control check on entity {} for the operation {}.", (Object)entityName, (Object)operation);
        AuthorizationService.setWhereCondition(null);
        Authorization auth = AuthorizationService.getAuthorization();
        if (null != auth) {
            return auth.hasEntityAccess(entityName, operation);
        }
        return false;
    }

    public static String getWhereCondition() {
        log.debug("Getting where condition to restrict query.");
        Authorization auth = AuthorizationService.getAuthorization();
        if (null != auth) {
            return auth.getWhereCondition();
        }
        return "";
    }

    public static void setWhereCondition(String whereCondition) {
        log.debug("Setting where condition to restrict query {}", (Object)whereCondition);
        Authorization auth = AuthorizationService.getAuthorization();
        if (null != auth) {
            auth.setWhereCondition(whereCondition);
        }
    }

    public static String getUserName() {
        log.debug("Getting where condition to restrict query.");
        Authorization auth = AuthorizationService.getAuthorization();
        if (null != auth) {
            return auth.getUserName();
        }
        return "";
    }

    public static String getUserId() {
        log.debug("Getting current user's id.");
        Authorization auth = AuthorizationService.getAuthorization();
        if (null != auth) {
            return auth.getUserId();
        }
        return null;
    }

    public static boolean hasUserRole(String roleName) {
        log.debug("Checking current user's role has {}", (Object)roleName);
        Authorization auth = AuthorizationService.getAuthorization();
        if (null != auth) {
            return auth.hasUserRole(roleName);
        }
        return false;
    }

    public static String getUserAttribute(String attributeName) {
        log.debug("Getting current user's attribute {}", (Object)attributeName);
        Authorization auth = AuthorizationService.getAuthorization();
        if (null != auth) {
            return auth.getUserAttribute(attributeName);
        }
        return null;
    }

    public static boolean isContainerSecurityEnabled() {
        return isContainerSecurityEnabled;
    }

    public static void setContainerSecurityEnabled(boolean isContainerSecurityEnabled) {
        AuthorizationService.isContainerSecurityEnabled = isContainerSecurityEnabled;
    }

    @Deprecated
    public static boolean isContainerSecurityEnable() {
        return isContainerSecurityEnabled;
    }

    @Deprecated
    public static void setContainerSecurityEnable(boolean isContainerSecurityEnabled) {
        AuthorizationService.isContainerSecurityEnabled = isContainerSecurityEnabled;
    }

    public static AuthJWTToken getJWTToken() {
        if (jwtTokenStore.get() == null) {
            AuthorizationService.getAuthorization();
        }
        return (AuthJWTToken)jwtTokenStore.get();
    }

    public static void setJWTToken(String base64EncodedJWTStr) {
        jwtTokenStore.set(new AuthJWTToken(base64EncodedJWTStr));
    }

    public static void setJWTToken(String base64EncodedJWTStr, JsonObject jwtJson) {
        jwtTokenStore.set(new AuthJWTToken(base64EncodedJWTStr, jwtJson));
    }

    public static Object getUserInfo() {
        if (userInfoStore.get() == null) {
            AuthorizationService.getAuthorization();
        }
        return userInfoStore.get();
    }

    public static void setUserInfo(Object userInfo) throws IllegalArgumentException {
        try {
            if (Class.forName(USER_INFO_CLASS).isInstance(userInfo)) {
                userInfoStore.set(userInfo);
            }
        }
        catch (ClassNotFoundException e) {
            String msg = "setUserInfo expects instance of com.sap.xs2.security.container.UserInfo class";
            logger.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg);
        }
    }

    public static void purgeCurrentAuthorization() {
        if (null != authorizationFactory.get()) {
            log.debug("Destroying Authorization Object.");
            authorizationFactory.remove();
        }
        if (null != jwtTokenStore.get()) {
            log.debug("Destroying Authorization JWT Token.");
            jwtTokenStore.remove();
        }
        if (null != userInfoStore.get()) {
            log.debug("Destroying Authorization UserInfo Object.");
            userInfoStore.remove();
        }
    }
}

