/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.sap.cloud.sdk.service.prov.api.security.Operator;

public class Operand {
    private final String value;

    public Operand(String value) {
        this.value = value;
    }

    public Operand transformToInfixOperand(Operator operator, Operand operand) {
        StringBuilder sb = new StringBuilder("(");
        sb.append(this.getValue());
        sb.append(" ");
        sb.append(operator.getValue());
        sb.append(" ");
        sb.append(operand.getValue());
        sb.append(")");
        return new Operand(sb.toString());
    }

    public Operand getOperandWithPrefixedAliasCDS(String alias, boolean isPlainSqlMapping) {
        if (alias == null || "".equals(alias)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(alias);
        if (isPlainSqlMapping) {
            sb.append(this.getValue().toUpperCase());
        } else {
            sb.append(this.getValue());
        }
        return new Operand(sb.toString());
    }

    public Operand getOperandWithPrefixedAlias(String alias, boolean isPlainSqlMapping) {
        if (alias == null || "".equals(alias)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(alias);
        if (!isPlainSqlMapping) {
            sb.append('\"');
        }
        sb.append(this.getValue());
        if (!isPlainSqlMapping) {
            sb.append('\"');
        }
        return new Operand(sb.toString());
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

