/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import java.util.HashMap;
import java.util.Map;

public enum Operator {
    OR(1, "OR", "OR"),
    AND(2, "AND", "AND"),
    IN(3, "IN", "IN"),
    IS(3, "IS", "IS"),
    EQ(3, "=", "EQ"),
    GT(3, ">", "GT"),
    GT_EQ(3, ">=", "GTEQ"),
    ST(3, "<", "ST"),
    ST_EQ(3, "<=", "STEQ"),
    NOT_EQ(3, "!=", "NOTEQ"),
    NOT(4, "!", "NOT");

    final int precedence;
    final String value;
    final String encodedValue;

    private Operator(int precedence, String operatorValue, String encodingSeed) {
        this.precedence = precedence;
        this.value = operatorValue;
        this.encodedValue = "#" + encodingSeed + "#";
    }

    public static Map<String, Operator> getValueMap() {
        HashMap<String, Operator> operatorMap = new HashMap<String, Operator>();
        for (Operator s : Operator.values()) {
            operatorMap.put(s.value, s);
        }
        return operatorMap;
    }

    public static Map<String, Operator> getEncodedValueMap() {
        HashMap<String, Operator> encodedOperatorMap = new HashMap<String, Operator>();
        for (Operator s : Operator.values()) {
            encodedOperatorMap.put(s.encodedValue, s);
        }
        return encodedOperatorMap;
    }

    public String getValue() {
        return this.value;
    }

    public String getEncodedValue() {
        return this.encodedValue;
    }

    public int getPrecedence() {
        return this.precedence;
    }
}

