/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.service.prov.api.security.AccessGrantDetails;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationDetails;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationRulesContainer;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationService;
import com.sap.cloud.sdk.service.prov.api.security.ExpressionExecutorUtil;
import com.sap.cloud.sdk.service.prov.api.security.JWTUtil;
import com.sap.cloud.sdk.service.prov.api.security.Operator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtil {
    public static final List<String> SYSTEM_USER_GRANT_TYPES = Collections.unmodifiableList(Arrays.asList("client_credentials", "client_x509"));
    private static final String USER_ATTRIBUTES = "xs.user.attributes";
    private static final String SYSTEM_USER_SCOPE = "system-user";
    private static final String AUTHENTICATED_USER = "authenticated-user";
    private static final String SYSTEM_USER = "system-user";
    private static final String ANY = "any";
    private static final String USER_NAME = "user_name";
    private static final String ZID = "zid";
    private static final String USER = "user";
    private static final String USER_ID = "user_id";
    private static final String TENANT = "tenant";
    private static final String OPEN_ID = "openid";
    private static final String ONLY_WHERE_GRANTS = "OnlyWhereGrants";
    private static final String BOTH_TO_AND_WHERE_GRANTS = "BothToAndWhereGrants";
    private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);

    private SecurityUtil() {
    }

    public static boolean checkUserAccess(AuthorizationDetails authDetails, List<String> scopes, JsonObject userAttributes, String operation) {
        boolean isAllowed = false;
        List<AccessGrantDetails> grantDetails = authDetails.getRestrict();
        AuthorizationService.setWhereCondition(null);
        HashMap grantTypes = new HashMap();
        grantTypes.put(ONLY_WHERE_GRANTS, new ArrayList());
        grantTypes.put(BOTH_TO_AND_WHERE_GRANTS, new ArrayList());
        for (AccessGrantDetails grantDetail : grantDetails) {
            if (!SecurityUtil.checkGrant(grantDetail, operation)) continue;
            if (grantDetail.getTo() != null && grantDetail.getWhere() == null && scopes.contains(grantDetail.getTo())) {
                isAllowed = true;
                break;
            }
            if (grantDetail.getTo() != null && scopes.contains(grantDetail.getTo()) && grantDetail.getWhere() != null) {
                ((List)grantTypes.get(BOTH_TO_AND_WHERE_GRANTS)).add(grantDetail);
                continue;
            }
            if (grantDetail.getTo() != null || grantDetail.getWhere() == null) continue;
            ((List)grantTypes.get(ONLY_WHERE_GRANTS)).add(grantDetail);
        }
        if (!isAllowed && userAttributes != null) {
            List grantDetailsWithWhere = null;
            grantDetailsWithWhere = ((List)grantTypes.get(BOTH_TO_AND_WHERE_GRANTS)).size() > 0 ? (List)grantTypes.get(BOTH_TO_AND_WHERE_GRANTS) : (List)grantTypes.get(ONLY_WHERE_GRANTS);
            ArrayList<String> whereList = new ArrayList<String>();
            for (AccessGrantDetails grantDetail : grantDetailsWithWhere) {
                try {
                    String updatedExpression = ExpressionExecutorUtil.buildExpression(grantDetail.getWhere(), userAttributes);
                    if (updatedExpression.startsWith("SPECIAL~")) {
                        String whereCondition = updatedExpression.replace("SPECIAL~", "");
                        whereList.add(whereCondition);
                    } else {
                        isAllowed |= ExpressionExecutorUtil.executeExpression(updatedExpression);
                    }
                }
                catch (ScriptException e) {
                    log.error("Error while evaluating expression ", (Throwable)e);
                }
                if (!isAllowed) continue;
                break;
            }
            if (!isAllowed && whereList.size() > 0) {
                StringBuilder sb = new StringBuilder();
                boolean firstFlag = true;
                for (String whereCond : whereList) {
                    if (firstFlag) {
                        firstFlag = false;
                        sb.append(whereCond);
                        continue;
                    }
                    sb.append(" " + Operator.OR.getValue() + " ");
                    sb.append(whereCond);
                }
                AuthorizationService.setWhereCondition(sb.toString());
                isAllowed = true;
            }
        }
        return isAllowed;
    }

    private static boolean checkGrant(AccessGrantDetails grantDetail, String operation) {
        if (operation.equals("*")) {
            return true;
        }
        List<String> grants = grantDetail.getGrant();
        if (grants != null) {
            return grants.contains(operation);
        }
        return false;
    }

    public static boolean isAuthenticatedUser(AuthorizationDetails authDetails, String serviceName) {
        boolean isAuthenticatedUser = false;
        List<String> requires = authDetails.getRequires();
        List<String> assignedScopes = JWTUtil.getScopes();
        for (String require : requires) {
            if (assignedScopes.contains(require)) {
                isAuthenticatedUser = true;
            } else if (AUTHENTICATED_USER.equalsIgnoreCase(require)) {
                isAuthenticatedUser = assignedScopes.contains(OPEN_ID);
            } else if ("system-user".equalsIgnoreCase(require)) {
                isAuthenticatedUser = SYSTEM_USER_GRANT_TYPES.contains(JWTUtil.getGrantType());
            } else if (ANY.equalsIgnoreCase(require)) {
                isAuthenticatedUser = true;
            }
            if (!isAuthenticatedUser) continue;
            break;
        }
        return isAuthenticatedUser;
    }

    public static boolean hasEntityAccess(String entityName, String operation) {
        log.debug("Authorization Check for Service: {} and Operation: {}", (Object)entityName, (Object)operation);
        JsonObject userAttributes = null;
        AuthorizationDetails authDetails = AuthorizationRulesContainer.getRule(entityName);
        JsonElement userAttributesElement = JWTUtil.getValueFromJwt(USER_ATTRIBUTES);
        if (null != userAttributesElement) {
            userAttributes = userAttributesElement.getAsJsonObject();
            userAttributes.add(USER, JWTUtil.getValueFromJwt(USER_NAME));
        }
        JsonElement zid = JWTUtil.getValueFromJwt(ZID);
        if (userAttributes == null && zid != null) {
            userAttributes = new JsonObject();
        }
        if (zid != null) {
            userAttributes.add(TENANT, zid);
        }
        List<String> userScopes = JWTUtil.getScopes();
        if (SYSTEM_USER_GRANT_TYPES.contains(JWTUtil.getGrantType())) {
            userScopes.add("system-user");
        }
        if (authDetails != null) {
            return SecurityUtil.checkUserAccess(authDetails, userScopes, userAttributes, operation);
        }
        return false;
    }

    public static boolean hasUserRole(String roleName) {
        List<String> userScopes = JWTUtil.getScopes();
        return userScopes.contains(roleName);
    }

    public static String getUserId() {
        return JWTUtil.getJWTAttribute(USER_ID);
    }

    public static String getUserName() {
        return JWTUtil.getJWTAttribute(USER_NAME);
    }
}

