/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.transaction.impl;

import com.sap.cloud.sdk.service.prov.api.exception.TransactionException;
import com.sap.cloud.sdk.service.prov.api.transaction.TransactionManager;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandler {
    private static ThreadLocal<ArrayList<TransactionManager>> transactionManagers = new ThreadLocal<ArrayList<TransactionManager>>(){

        @Override
        protected ArrayList<TransactionManager> initialValue() {
            return new ArrayList<TransactionManager>();
        }
    };
    static final Logger logger = LoggerFactory.getLogger(TransactionHandler.class);
    private static ThreadLocal<Boolean> isChangeSet = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Status> status = new ThreadLocal<Status>(){

        @Override
        protected Status initialValue() {
            return Status.NO_TRANSACTION;
        }
    };
    private static ThreadLocal<Boolean> isCleanUpDone = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static void addTransactionManager(TransactionManager transactionManager) {
        if (transactionManagers.get().size() == 0) {
            isCleanUpDone.set(false);
            status.set(Status.NO_TRANSACTION);
            isChangeSet.set(false);
        }
        transactionManagers.get().add(transactionManager);
    }

    public static Boolean isInitialized() {
        return transactionManagers.get().size() != 0;
    }

    public static void startChangeSetTransaction() {
        TransactionHandler.startTransaction();
        isChangeSet.set(true);
    }

    public static void endChangeSetTransaction() {
        isChangeSet.set(false);
    }

    public static void startTransaction() {
        if (isChangeSet.get().booleanValue()) {
            return;
        }
        if (TransactionHandler.isActive()) {
            TransactionHandler.commitTransaction();
        }
        status.set(Status.ACTIVE);
        for (TransactionManager transactionManager : transactionManagers.get()) {
            try {
                transactionManager.startTransaction();
            }
            catch (TransactionException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void commitTransaction() {
        if (isChangeSet.get().booleanValue()) {
            return;
        }
        Status state = status.get();
        if (state == Status.NO_TRANSACTION) {
            return;
        }
        if (state == Status.MARKED_FOR_ROLLBACK) {
            TransactionHandler.rollbackTransaction();
            throw new RuntimeException("The transaction has been rolled back rather than committed");
        }
        status.set(Status.NO_TRANSACTION);
        for (TransactionManager transactionManager : transactionManagers.get()) {
            try {
                transactionManager.commitTransaction();
            }
            catch (TransactionException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void rollbackTransaction() {
        if (status.get() == Status.NO_TRANSACTION) {
            logger.debug("Rollback transaction called, but transaction not actually started. Ignoring rollback call.");
            return;
        }
        status.set(Status.NO_TRANSACTION);
        for (TransactionManager transactionManager : transactionManagers.get()) {
            try {
                transactionManager.rollbackTransaction();
            }
            catch (TransactionException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void cleanupTransaction() {
        if (isCleanUpDone.get().booleanValue()) {
            return;
        }
        if (isChangeSet.get().booleanValue()) {
            return;
        }
        status.set(Status.NO_TRANSACTION);
        for (TransactionManager transactionManager : transactionManagers.get()) {
            transactionManager.cleanupTransaction();
        }
        isCleanUpDone.set(true);
        transactionManagers.get().clear();
    }

    public static boolean isActive() {
        return status.get() != Status.NO_TRANSACTION;
    }

    public static void setRollbackOnly() {
        if (status.get() == Status.ACTIVE) {
            status.set(Status.MARKED_FOR_ROLLBACK);
        }
    }

    private static enum Status {
        NO_TRANSACTION,
        ACTIVE,
        MARKED_FOR_ROLLBACK;

    }
}

