/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sap.cloud.sdk.service.prov.api.annotations.Key;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanMap;

public class PojoUtil {
    private static ObjectMapper getMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static Map<String, Object> getMapFromPojo(Object pojo) {
        return (Map)PojoUtil.getMapper().convertValue(pojo, HashMap.class);
    }

    public static <T> T getPojoFromMap(Class<T> clazz, Map<String, Object> data) {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.convertValue(data, clazz);
    }

    public static <T> List<String> getKeyProperties(T p) {
        Field[] ss = p.getClass().getDeclaredFields();
        return Arrays.asList(ss).stream().filter(propertyElement -> propertyElement.getDeclaredAnnotation(Key.class) != null).map(propertyElement -> propertyElement.getName()).collect(Collectors.toList());
    }

    public static Map<String, Object> getMapUsingBeanUtils(Object pojo) {
        if (pojo instanceof Map) {
            return (Map)pojo;
        }
        List pojoFields = Arrays.asList(pojo.getClass().getDeclaredFields()).stream().map(f -> f.getName()).collect(Collectors.toList());
        HashMap pojoAsMap = new HashMap();
        BeanMap beanMap = new BeanMap(pojo);
        HashMap<String, Object> finalMap = new HashMap<String, Object>();
        beanMap.entrySet().stream().forEach(e -> pojoAsMap.put(e.getKey().toString().toLowerCase(), e.getValue()));
        for (String fieldName : pojoFields) {
            if (!pojoAsMap.containsKey(fieldName.toLowerCase())) continue;
            finalMap.put(fieldName, pojoAsMap.get(fieldName.toLowerCase()));
        }
        return finalMap;
    }
}

