/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.annotation.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationContainer<T>{
	
	private static AnnotationContainer<?> _instance = null; 
	private static List<Class<?>> annotationClasses = new ArrayList<Class<?>>();
	
	private AnnotationContainer(){
		 
	}
	 
	public static synchronized AnnotationContainer<?> getInstance() {
		 if(_instance==null) {
			 _instance = new AnnotationContainer<>();
		 }
		 return _instance;
	 }
	
	public synchronized void addAnnotation(Class<?> _class) {
		annotationClasses.add(_class);
	}
	
	public synchronized List<Class<?>> getAnnotationList() {
		return Collections.unmodifiableList(annotationClasses);
	}
}
