/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
/* 
 * This class is an intellectual property of SAP.
 * Any usage or distribution outside the agreed terms
 * and conditions of the license is prohibited.
 * See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.
 * you may not use this file except in compliance
 * with the License.Unless required by applicable law
 * or agreed to in writing,software distributed under 
 * the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY * KIND, either express 
 * or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 * 2017
 */
package com.sap.cloud.sdk.service.prov.annotation.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/**
 * 
 * 
 * @since 25/03/2017
 * @version 0.1
 * Description : This component serves as the repository for classes and methods associated with a particular odata v4
 *               annotation as supported by Cloud Extension SDK for OData Provisioning and consumption
 * Last Modified : 25/03/2017
 * @param <T>
 */
public class AnnotationRepository<T> {

	 private static Logger log = LoggerFactory.getLogger(AnnotationRepository.class);
	
	 @SuppressWarnings("rawtypes")
	 private static AnnotationRepository _instance = null; 
	 private static Map<String, List<AnnotatedClassMethod<?>>> annoClassMethodMap = new HashMap<String, List<AnnotatedClassMethod<?>>>();
	 
	 private AnnotationRepository(){
		 
	 }
	 
	 /**
	  * To get an instance of AnnotationRepository Class
	  * @return AnnotationRepository
	  */
	 public static synchronized AnnotationRepository<?> getInstance() {
		 if(_instance==null) {
			 _instance = new AnnotationRepository<>();
		 }
		 if(log.isDebugEnabled()) {
			 log.debug("AnnotationRepository Instance :"+_instance);
		 }
		 return _instance;
	 }

	/**
	 * Use this method to get a List of AnnotatedClassMethod object based on annotation name
	 * @param String:annotationName
	 * @return List<AnnotatedClassMethod<?>>
	 */
	public List<AnnotatedClassMethod<?>> getClassMethodListForAnnotation(String annotationName) {
		if(log.isDebugEnabled()) {
			 log.debug("getClassMethodListForAnnotation :"+annotationName+" "+annoClassMethodMap.get(annotationName));
		}
		return annoClassMethodMap.get(annotationName);
	}

	/**
	 * Use this method to register a list of AnnotatedClassMethod object against a particular Odata V4 annotation
	 * @param annotationName
	 * @param list
	 */
	public  synchronized void registerAnnotationClassMethod(String annotationName, AnnotatedClassMethod<?> annoClassMthod) {
		if(log.isDebugEnabled()) {
			 log.debug("registerAnnotationClassMethod :"+annotationName+" "+annoClassMthod);
		}
		
		if(annoClassMethodMap.containsKey(annotationName)) {
			List<AnnotatedClassMethod<?>> existingList = annoClassMethodMap.get(annotationName);
			existingList.add(annoClassMthod);
			annoClassMethodMap.put(annotationName,existingList);
		}else {
			List<AnnotatedClassMethod<?>> newList = new ArrayList<AnnotatedClassMethod<?>>();
			newList.add(annoClassMthod);
			annoClassMethodMap.put(annotationName,newList);
		}
	}
	 
}
