/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api;

import com.sap.cloud.sdk.service.prov.api.request.Request;
import com.sap.cloud.sdk.service.prov.api.response.Response;

/**
 * Provides the control to retrieve the request, process it,
 * and add the corresponding response for each operation in the changeset.
 */
public interface ChangeSetHandler {
	
	/**
	 * Returns true, if the changeset has additional operations, otherwise, it returns false.
	 * Please note this method returns false, if an exception occurs while processing the changeset.
	 * @return A <code>boolean</code> indicating the presence of next request
	 */
	public boolean hasNextRequest();
	
	/**
	 * Returns request information corresponding to the next operation in the changeset.
	 * Please note this method returns null, if an exception occurs while processing the changeset.
	 * @return A <code>Request</code> object corresponding to the next operation
	 * @throws <code>Exception</code> if either the replacement of the content ID or
	 * the request deserialization fails
	 */
	public Request nextRequest() throws Exception;

	/**
	 * Executes the annotated method corresponding to the data modification operations.
	 * This annotated method is invoked based on the HTTP method, service name,
	 * and entity name specified in the request. 
	 * @param request A <code>Request</code> object corresponding to an operation
	 * @return A <code>Response</code> object corresponding to the processed operation
	 * @throws <code>Exception</code> if the annotated method corresponding to the operation is not defined
	 */
	public Response handleRequest(Request request) throws Exception;
	
	/**
	 * Appends the response to the changeset and returns true if successful.
	 * Please note this method returns false, if an exception occurs while processing the changeset.
	 * @param response A <code>Response</code> object corresponding to an operation
	 * @return <code>boolean</code> indicating success or failure
	 * @throws <code>Exception</code> if the response object contains an exception,
	 * response serialization fails, or the content ID mapping fails
	 */
	public boolean addResponse(Response response) throws Exception;
		
}
