/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api;

public interface EntityDataBuilder {

	/**
	 * Adds an element and its value to the EntityData which will be built from this EntityDataBuilder object.
	 * This method can be used to add simple as well as structured elements. In the latter case
	 * the value should be an instance of HashMap which has the values of the structured type.
	 * 
	 * @param name Name of the element
	 * @param value Value of the element
	 * @return The current EntityDataBuilder
	 */
	EntityDataBuilder addElement(String name, Object value);

	/**
	 * Removes an element from the EntityData which is built using this EntityDataBuilder object.
	 * @param name Name of the element
	 * @return The current EntityDataBuilder
	 */
	EntityDataBuilder removeElement(String name);

	/**
	 * Adds a key element and its value to the EntityData which will be built from this EntityDataBuilder object.
	 * If the element already exists in the builder its value will be overwritten with the new value
	 * passed as parameter.
	 * @param name Name of the key element
	 * @param value Value of the key element
	 * @return The current EntityDataBuilder
	 */
	EntityDataBuilder addKeyElement(String name, Object value);

	/**
	 * Builds and returns an entityData based on the current initialized values of the EntityDataBuilder.
	 * 
	 * @param name The name of the Entity that would be represented by the created EntityData
	 * @return The created EntityData
	 */
	EntityData buildEntityData(String name);
	
	/**
	 * Adds an association element and its value to the EntityData which will be built from this EntityDataBuilder object.
	 * This method can be used to add one element as well as list of elements. In the latter case,
	 * the value must be an instance of HashMap which has the values of the association.
	 * 
	 * @param name Name of the association element
	 * @param value Value of the association element
	 * @return The current EntityDataBuilder
	 */
	EntityDataBuilder addAssociationElement(String name, Object value);

}
