/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api;

import java.util.List;


public interface EntityMetadata extends StructuredTypeMetadata{

	/**
	 * 
	 * @return Key element names if keys are present, empty list otherwise.
	 */
	public List<String> getKeyNames();
	
	/**
	 * 
	 * @return namespace if present, null otherwise.
	 */
	public String getNamespace();
	
	/**
	 * @param associationName
	 * @return entityMetadata if present, null otherwise.
	 */
	public EntityMetadata getAssociationMetaData(String associationName);
	
	/**
	 * Gets the names of the associations in the entity including those
	 * associations for which there is no data in the EntityData.
	 * @return List of associations of the entity
	 */
	public List<String> getAssociationNames();
}
