/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api;

import com.sap.cds.CdsDataStore;
import com.sap.cds.reflect.CdsModel;

/**
 * Provides utility methods that help in implementing custom handlers.
 */
public interface ExtensionHelper {

	/**
	 * Returns the DataSourceHandler object with which you can execute any operation
	 * (Create, Read, Update, Delete, or Query) on a data source.
	 * 
	 * @return An instance of DataSourceHandler
	 */
	public DataSourceHandler getHandler();

	/**
	 * Returns the CdsDataStore instance, which allows to interact with a data
	 * source, it allows to execute CDS QL queries, as well as insert, update and
	 * delete.
	 * 
	 * @return the CdsDataStore instance
	 */
	public CdsDataStore getCdsDataStore();

	/**
	 * Returns the CdsModel instance, which reflects the CDS model.
	 * 
	 * @return the CdsModel
	 */
	public CdsModel getCdsModel();

}
