/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api;

public interface MessageContainer {

	/**
	 * Adds a (non-leading)message with severity error. 
	 * The message text of the message will be obtained from a properties file based on the messageKey parameter.
	 * The messageKey parameter also becomes the "code" of the message.
	 * Parameters is taken through a variable length array of objects. These objects will be stringified and substituted in
	 * the messageText in place of parameter place holders. In case there are no parameters, just don't pass any objects for
	 * this argument.
	 * Once the message is added to the container by calling this api, it can come as part of details under the
	 * value of the sap-message header,
	 * or as error detail in an error response based on the calls taken by the developer. 
	 * 
	 * @param messageKey messageKey associated with the message, used as the key to a properties file to retrieve the message text.
	 * @param target Target for which this message applies.
	 * @param params Parameters which will be substituted in the messageText in place of placeholders.
	 */
	public void addErrorMessage(String messageKey, String target, Object... params);

	/**
	 * Sets the leading message. The message text of the message will be obtained from a properties file based on the messageKey parameter.
	 * The messageKey parameter also becomes the "code" of the message.
	 * Parameters is taken through a variable length array of objects. These objects will be stringified and substituted in
	 * the messageText in place of parameter place holders. In case there are no parameters, just don't pass any objects for
	 * this argument.
	 * This will be the leading message under the value of the sap-message header. The severity is always success for the leading message.
	 * 
	 * @param messageKey messageKey associated with the message, used as the key to a properties file to retrieve the message text.
	 * @param target Target for which this message applies.
	 * @param params Parameters which will be substituted in the messageText in place of placeholders.
	 */
	public void setLeadingMessage(String messageKey, String target, Object... params);

	/**
	 * Adds a (non-leading)message with severity warning. 
	 * The message text of the message will be obtained from a properties file based on the messageKey parameter.
	 * The messageKey parameter also becomes the "code" of the message.
	 * Parameters is taken through a variable length array of objects. These objects will be stringified and substituted in
	 * the messageText in place of parameter place holders. In case there are no parameters, just don't pass any objects for
	 * this argument.
	 * Once the message is added to the container by calling this api, it can come as part of details under the
	 * value of the sap-message header,
	 * or as error detail in an error response based on the calls taken by the developer.
	 * 
	 * @param messageKey messageKey associated with the message, used as the key to a properties file to retrieve the message text.
	 * @param target Target for which this message applies.
	 * @param params Parameters which will be substituted in the messageText in place of placeholders.
	 */
	public void addWarningMessage(String messageKey, String target, Object... params);

	/**
	 * Adds a (non-leading)message with severity info.
	 * The message text of the message will be obtained from a properties file based on the messageKey parameter.
	 * The messageKey parameter also becomes the "code" of the message.
	 * Parameters is taken through a variable length array of objects. These objects will be stringified and substituted in
	 * the messageText in place of parameter place holders. In case there are no parameters, just don't pass any objects for
	 * this argument.
	 * Once the message is added to the container by calling this api, it can come as part of details under the
	 * value of the sap-message header,
	 * or as error detail in an error response based on the calls taken by the developer.
	 * 
	 * @param messageKey messageKey associated with the message, used as the key to a properties file to retrieve the message text.
	 * @param target Target for which this message applies.
	 * @param params Parameters which will be substituted in the messageText in place of placeholders.
	 */
	public void addInfoMessage(String messageKey, String target, Object... params);
	
	/**
	 * Adds a (non-leading)message with severity success.
	 * The message text of the message will be obtained from a properties file based on the messageKey parameter.
	 * The messageKey parameter also becomes the "code" of the message.
	 * Parameters is taken through a variable length array of objects. These objects will be stringified and substituted in
	 * the messageText in place of parameter place holders. In case there are no parameters, don't pass any objects for
	 * this argument.
	 * Once the message is added to the container by calling this api, it can come as part of details under the
	 * value of the sap-message header,
	 * or as error detail in an error response based on the calls taken by the developer.
	 * 
	 * @param messageKey messageKey associated with the message, used as the key to a properties file to retrieve the message text.
	 * @param target Target for which this message applies.
	 * @param params Parameters which will be substituted in the messageText in place of placeholders.
	 */
	public void addSuccessMessage(String messageKey, String target, Object... params);

}
