/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

import com.sap.cloud.sdk.service.prov.api.connection.ThreadSafeObjectStore;

/**
 * Provides access to the current request's metadata and its last modifed timee.
 */
public class ServiceMetadata {
	
	/**
	 * Gets the tenant-specific metadata of the current request.
	 *  
	 * @return An {@link java.io.InputStream InputStream} object containing the tenant specific metadata
	 */
	public static InputStream getMetadataAsStream() {
		ByteArrayOutputStream baos = ThreadSafeObjectStore.getMetadataForCurrentThread();
		return new ByteArrayInputStream(baos.toByteArray());
	}
	
	/**
	 * Gets the last modified time of the current metdata
	 *  
	 * @return An {@link java.sql.Timestamp Timestamp} object containing the last modified time of the tenant
	 */
	public static Timestamp getLastModifiedTime() {
		Instant lastModifiedDate = ThreadSafeObjectStore.getMetadataLastModifiedTime();
		LocalDateTime ldt = LocalDateTime.ofInstant(lastModifiedDate, ZoneOffset.UTC);
		return Timestamp.valueOf(ldt);
	}
	
}
