/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api;

import java.util.List;


/**
 * This API is used to introspect the structure of a StructuredType like ComplexType property.
 *
 */
public interface StructuredTypeMetadata {
	
	/**
	 * Gets the name of the entity.
	 * @return name of the Entity represented by this EntityMetadata.
	 */
	public String getName();
	
	/**
	 * Gets the names of the elements in the entity including those elements
	 *  for which there is no data in the EntityData.
	 * @return List of element of the entity.
	 */
	public List<String> getElementNames();
	
	/**
	 * Gets the flattened names of the elements in the entity.
	 * Here flattened means that individual elements of a structured type will come as separate elements with name being the dot separated path starting from
	 * the structured type name till the element name. For simple elements coming directly under the entity, the name will simply be the element name.
	 * 
	 * For example:- If an entity Customer has elements CustomerID, Name, Address, where Address is a structured type with sub elements City, Country,
	 * Then a call to getFlattenedElementNames will return the list {CustomerID, Name, Address.City, Address.Country}.
	 * 
	 * @return List of element of the entity.
	 */
	public List<String> getFlattenedElementNames();

	/**
	 * Gets the type of the element 
	 * @param elementName
	 * @return ElementType
	 */
	public ElementType getElementType(String elementName);
	
	/**
	 * Gets the Metadata of a Structured Type
	 *@return StructuredTypeMetadata representing Metadata of Structured Type.
	 */
	public StructuredTypeMetadata getStructuredTypeMetadata(String structuredTypeName);
}
