/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api;

import java.util.HashMap;

@SuppressWarnings("rawtypes")
public class TypeMapping {
	
	private HashMap<String,Class> csnTypeMap = new HashMap<String,Class>();
	private HashMap<String,Class> edmTypeMap = new HashMap<String,Class>();
	private HashMap<String,Class> combinedTypeMap = new HashMap<String,Class>();
	
	public Class getMappedType(String CSNType,String EdmType){
		if(CSNType!=null && EdmType!=null)
			return combinedTypeMap.get(CSNType+":"+EdmType);
		if(CSNType!=null)
			return csnTypeMap.get(CSNType);
		if(EdmType!=null)
			return edmTypeMap.get(EdmType);
		
		return null;
	}
	
	public void registerTypeMap(String CSNType, String EdmType, Class mappedJavaType){
		if(CSNType!=null && EdmType!=null)
			combinedTypeMap.put(CSNType + ":" + EdmType, mappedJavaType);
		if(EdmType!=null)
			edmTypeMap.put(EdmType, mappedJavaType);
		if(CSNType!=null)
			csnTypeMap.put(CSNType, mappedJavaType);
	}
}
