/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
* <p>The <code>AfterQuery</code> annotation attached to a public method specifies that the method executes
* after the Query operation on an entity in a service.</p>
*
* <p> A method to which this annotation is attached must provide the following:
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.QueryRequest QueryRequest}
* 		</li>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.response.QueryResponseAccessor QueryResponseAccessor}
* 		</li>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.ExtensionHelper ExtensionHelper}
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.response.QueryResponse QueryResponse}
* 		</li>
* 	</ol>
*  </p>
*
* @param entity Name of the entity
* @param serviceName [optional] Name of the service to which the entity belongs
*/
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface AfterQuery {
	String serviceName() default "";
	String[] entitySet() default {};
	String entity() default "";
}
