/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
* <p>The <code>BeforeALL</code> annotation attached to a public method specifies that the method executes
* Before all operations in a service/s.</p>
*
* <p> A method to which this annotation is attached must provide the following:
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.GenericRequest GenericRequest}
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.exits.BeforeAllResponse BeforeAllResponse}
* 		</li>
* 	</ol>
*  </p>
*
* @param [optional] Array of serviceNames,  by default all services are considered. 
* @deprecated As of version 1.18.0, replaced by {@link InitTransaction} 
*/

@Deprecated
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface BeforeAll {
	String[] serviceNames() default {};
}
