/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
* <p>The <code>BeforeCreateDraft</code> annotation attached to a public method specifies that the method executes
* before the Create operation on an Draft entity in a service.</p>
*
* <p> A method to which this annotation is attached must provide the following:
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.CreateRequest CreateRequest}
* 		</li>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.ExtensionHelper ExtensionHelper}
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.exits.BeforeCreateResponse BeforeCreateResponse}
* 		</li>
* 	</ol>
*  </p>
*
* @param entity Name of the entity
* @param serviceName [optional] Name of the service to which the entity belongs
*/
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface BeforeCreateDraft {
	String serviceName() default "";
	String[] entitySet() default {};
	String entity() default "";
}
