/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
/**
* <p>The <code>BeforeOperation</code> annotation attached to a public method specifies
* that the method executes before the specified operation (either a function or an action) executes.</p>
*
* <p>
*  A method to which this annotation is attached supports two signatures depending on the following scenarios:
* </p>
* <p> 
* SCENARIO 1: You're executing the operation on your local HANA database.
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.OperationRequest OperationRequest}
* 		</li>
*   	<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.ExtensionHelper ExtensionHelper} 
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.response.OperationResponse OperationResponse}
* 		</li>
* 	</ol>
*  </p>
*  
* <p> 
* SCENARIO 2: You're executing the operation only on a remote data source.
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.OperationRequest OperationRequest}
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.response.OperationResponse OperationResponse}
* 		</li>
* 	</ol>
*  </p>
*  
* 
* @param serviceName Name of the service
* @param Name Name of the operation (function or action) within the service
*/

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface BeforeOperation {
	String serviceName() default "";
	String Name();
}
