/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
* <p>The <code>EndTransaction</code> annotation attached to a public method specifies that the method is
* invoked after all the operations in the transaction complete and before the transaction commits.</p>
*
* <p> A method to which this annotation is attached must provide the following:
* 	<ol>
* 		<li>
* 			Input parameter of type List<{@link com.sap.cloud.sdk.service.prov.api.request.Request Request}>
* 		</li>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.ExtensionHelper ExtensionHelper}
* 		</li>
* 	</ol>
*  </p>
*
* @param serviceName [optional] Name of the service. The annotated method applies to all entity sets within the specified
*                               service. If service name is not provided then this method executes for any entity set in
*                               any service.
*/
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface EndTransaction {
	String[] serviceNames() default {};
}
