/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
* <p>The <code>ExtendCreate</code> annotation attached to a public method specifies that the method implements
* the Create operation of an entity set in a service. This method overrides the default Create operation of
* the generic OData service provisioned by the SDK.</p>
*
* <p> A method to which this annotation is attached must provide the following:
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.CreateRequest CreateRequest}
* 		</li>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.ExtensionHelper ExtensionHelper}
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.response.CreateResponse CreateResponse}
* 		</li>
* 	</ol>
*  </p>
*
* @param entity Name of the entity 
* @param serviceName [optional] Name of the service to which the entity belongs
* 
* @deprecated As of version 1.16.0, replaced by {@link Create} 
*/
@Deprecated
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ExtendCreate {
	String serviceName() default "";
	String entity() default "";
	
	//Using entitySet name in the annotation does not makes sense as user only specify entity name in CDS. use entity instead.
	@Deprecated
	String[] entitySet() default {};
}
