/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
/**
* <p>The <code>ExtendFunction</code> annotation attached to a public method specifies
* that the method provides the implementation logic of a GET function import.</p>
*
* <p> A method to which this annotation is attached must provide the following: 
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.OperationRequest OperationRequest}
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.response.OperationResponse OperationResponse}
* 		</li>
* 	</ol>
*  </p> 
* 
* @param serviceName A <code>String</code> containing the name of the service
* @param Name A <code>String</code> containing the name of the function import within the service
* 
* @deprecated As of version 1.16.0, replaced by {@link Function} 
*/
@Deprecated
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ExtendFunction {
	String serviceName() default "";
	String Name();
}
