/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
* <p>The <code>ExtendReadStream</code> annotation attached to a public method specifies that the method implements
* the Read operation of a media entity in a service. This method overrides the default Read media entity operation
*  of the generic OData service provisioned by the SDK.</p>
*
* <p> A method to which this annotation is attached must provide the following:
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.ReadRequest ReadRequest}
* 		</li>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.ExtensionHelper ExtensionHelper}
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.response.ReadResponse ReadResponse}
* 		</li>
* 	</ol>
*  </p>
*
* @param entity Name of the entity
* @param serviceName [optional] Name of the service to which the entity belongs
*/
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ExtendReadStream {
	String serviceName() default "";
	String entity() default "";
}
