/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.exception;
/**
 * Thrown when the input data structure cannot be mapped to the target data structure   
 */
public class DataConversionException extends IllegalArgumentException {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Throwable cause;
	private String message;

	public DataConversionException(String message) {
		super(message);
		this.message = message;
	}

	public DataConversionException(String message, Throwable cause) {
		super(message, cause);
		this.message = message;
		this.cause = cause;
	}

	public Throwable getCause() {
		return cause;
	}
}
