/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.exception;

import com.sap.cloud.sdk.service.prov.api.DatasourceExceptionType;

public class DatasourceException extends Exception {

	DatasourceExceptionType type;
	Throwable exception;
	
	public DatasourceException(DatasourceExceptionType type, Throwable exception) {
		this.type = type;
		this.exception = exception;
	}
	
	/**
	 * Returns the DatasourceExceptionType of this exception. DatasourceExceptionType is an enum type whose value will give some
	 * indication as to the reason of the exception.
	 * @return DatasourceExceptionType
	 */
	public DatasourceExceptionType getType() {
		return type;
	}
	
	@Override
	public Throwable getCause() {
		return exception;
	}
	
	@Override
	public String getMessage() {
		if(exception != null)
			return exception.getMessage();
		return null;
	}
	
}
