/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.exits;

import com.sap.cloud.sdk.service.prov.api.response.ErrorResponse;

/**
 * Provides methods for creating a response object that must be returned from the BeforeDelete handler. 
 */
public interface BeforeDeleteResponse{
	
	/**
	 * Populates error in a BeforeDeleteResponse object and returns the same. 
	 * @param errorResponse An <code>ErrorResponse</code> object containing the error message and status code
	 * @return A <code>BeforeDeleteResponse</code> object containing the error
	 */
	public static PreExtensionResponseWithoutBody setError(ErrorResponse errorResponse){
		return new PreExtensionResponseImpl(errorResponse);
	}
	
	/**
	 * Returns a response builder to create a response when the BeforeDelete handler executes successfully.
	 * @return an instance of PreExtensionResponseBuilderWithoutBody
	 */
	public static PreExtensionResponseBuilderWithoutBody setSuccess(){
		return new PreExtensionResponseBuilderWithoutBody();
	}
	
}
