/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.exits;

import com.sap.cloud.sdk.service.prov.api.filter.Expression;

/**
 * setting expression
 */
public class PreExtensionQueryResponseBuilder extends PreExtensionResponseBuilderWithoutBody{
	
private Expression expression;
	

	public PreExtensionQueryResponseBuilder() {
	}

	/**
	 * Use this method in a BeforeQuery handler to return a response object in the event of a successful execution.
	 * @return A PreExtensionQueryResponseImpl object
	 */
	public PreExtensionResponseWithBody response(){
		return new PreExtensionResponseImpl(expression);
	}
	
	/**
	 * Use this method to add the modified FilterExpression of the current Query request represented as an Expression object.
	 * @param expression the Expression object that represents the modified Filter expression.
	 */
	public PreExtensionQueryResponseBuilder setExpression(Expression expression){
		this.expression = expression;
		return this;
	}
	
}
