/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.exits;

import com.sap.cloud.sdk.service.prov.api.EntityData;

/**
 * Provides methods for creating a response object from the BeforeCreate or BeforeUpdate handler in the 
 * event of a successful execution. 
 */
public class PreExtensionResponseBuilderWithBody {
	
	private Object data;
	
	public PreExtensionResponseBuilderWithBody(EntityData entityData) {
		this.data = entityData;
	}

	public PreExtensionResponseBuilderWithBody() {
	}

	/**
	 * Use this method in a BeforeCreate or BeforeUpdate handler to return a response object in the event of a successful execution.
	 * @return A PreExtensionResponseWithBody object
	 */
	public PreExtensionResponseWithBody response(){
		return new PreExtensionResponseImpl(data);
	}
	
	/**
	 * Use this method to add the modified request body of the current Create/Update request represented as an EntityData object.
	 * @param entityData the entityData object that represents the modified request body.
	 * @return A PreExtensionResponseBuilderWithBody object which contains the newly added entityData object.
	 */
	public PreExtensionResponseBuilderWithBody setEntityData(EntityData entityData){
		this.data = entityData;
		return this;
	}
	
	/**
	 * Use this method to add the modified request body of the current Create/Update request represented as a POJO.
	 * @param pojoData the POJO that represents the modified request body.
	 * @return A PreExtensionResponseBuilderWithBody object which contains the newly added POJO.
	 */
	public PreExtensionResponseBuilderWithBody setData(Object pojoData){
		this.data = pojoData;
		return this;
	}
	
}
