/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter;

/**
 * 
 * Represents a filter expression containing a binary operator.
 *
 */
public interface BinaryExpressionNode extends ExpressionNode {
	
	/**
	 * Gets the operator of the filter expression.
	 * 
	 * @return A string containing the operator
	 */
	public String getOperator();
	
	/**
	 * Gets the first child in the filter expression tree.
	 * 
	 * @return An <code>ExpressionNode</code> object containing the first child in the filter expression tree
	 */
	public ExpressionNode getFirstChild();
	
	/**
	 * Gets the second child in the filter expression tree.
	 * 
	 * @return An <code>ExpressionNode</code> object containing the second child in the filter expression tree
	 */
	public ExpressionNode getSecondChild();
}
