/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter;

import java.util.List;

public interface Expression {

	/**
	 * Gets all the leaf units of the expression tree. A leaf unit is a node with at least one leaf node as its child.
	 * For example, <code>Name eq 'John'</code> is a leaf unit within a bigger filter expression tree.
	 * 
	 * @param filterTreeNode Represents the filter expression tree
	 * @return A list of leaf units from the filter expression tree
	 */
	default List<ExpressionNode> getLeafUnitNodes()   {
		 return new ExpressionAPIUtility().getLeafUnits(this);
	 }
	
	/**
	 * Gets all the nodes from a filter expression tree.
	 * @param filterTree An <code>ExpressionNode</code> object which is the root node of a filter expression tree
	 * @return A list of <code>ExpressionNode</code> objects containing all nodes of a given filter expression tree
	 */
	default List<ExpressionNode> getNodes( ) {
		return new ExpressionAPIUtility().getNodes(this);
	}	
		 
}
