/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter;

import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.BINARY_OPERATOR;
import com.sap.cloud.sdk.service.prov.api.filter.exception.FilterOptionException;

public interface ExpressionBuilder {

	/**
	 * Creates a binary expression that comprises of a PropertyNode, LiteralNode, and the operator. 
	 * For example, <code>Name eq 'John'</code>. In this example, PropertyNode contains Name, LiteralNode contains 'John', and the operator is 'eq'.
	 * 
	 * @param path Name of the property
	 * @param operator Binary operator used to form the expression
	 * @param value Literal value used in the expression
	 * @return An Expression object containing the binary expression
	 * @throws FilterOptionException If an error occurs while creating the binary expression
	 */
	Expression createExpression(String path, BINARY_OPERATOR operator, Object value) throws FilterOptionException;
	
	/**
	 * Creates a  binary expression by combining two child expressions with an operator.
	 * @param left One of the child expressions used to build the binary expression
	 * @param operator Binary operator used to form the final expression
	 * @param right One of the child expressions used to build the binary expression
	 * @return An Expression object containing the final binary expression
	 * @throws FilterOptionException If an error occurs while creating the binary expression
	 */
	Expression createExpression(Expression left, BINARY_OPERATOR operator, Expression right)throws FilterOptionException; 
	
	/**
	 * Prepends the <code>not</code> operator to the expression. For example, not (Name eq %27John%27).
	 * @param filter Expression to be negated
	 * @return Expression with the <code>not</code> operator prepended to it
	 */
	Expression not(final Expression filter);
	
	/**
	 * Joins two expressions using the <code>and</code> binary operator.
	 * @param left One of the child expressions used to build the binary expression
	 * @param right One of the child expressions used to build the binary expression
	 * @return An Expression object containing the final binary expression
	 */
	Expression and(final Expression left, final Expression right);

}
