/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter;

public interface ExpressionOperatorTypes {
	
	/**
	 * Provides the types of node supported in a filter expression.
	 */
	public enum NODE_KIND {
 		UNARY, // Unary expression
 		BINARY, // Binary expression
 		LITERAL, // Literal expression
 		FUNCTION, // Function expression
 		PROPERTY, // Member access expression
  		COMPLEX_PROPERTY, // Complex Property expression
  		NAVIGATION_PROPERTY // Navigation Property expression
 	}
	
	/**
	 * Provides the operators supported in a filter expression.
	 *
	 */
	public enum OPERATOR{
		//Binary Comparator 
		EQ, NE, LT, GT, LE, GE ,
		//Binary Operator
		AND, OR,
		// Math function
        ADD, MUL, SUB, DIV, MOD,
        //Unary Operator
        NOT, MINUS
	}
	
 	
	/**
	 * Provides the operators supported in a binary filter expression.
	 */
	public enum BINARY_OPERATOR{
		//Binary Comparator 
		EQ, NE, LT, GT, LE, GE ,
		//Binary Operator
		AND, OR,
		// Math function
        ADD, MUL, SUB, DIV, MOD
		
	}
	

	/**
	 * Provides the operators supported in a unary filter expression.
	 */
	public enum UNARY_OPERATOR{
		//Unary Operator
		NOT, MINUS
	}
	
	/**
	 * Provides the functions supported in a filter expression.
	 */
	public enum FUNCTION {
 		CONCAT, CONTAINS, ENDSWITH, INDEXOF, LENGTH, STARTSWITH, SUBSTRING, TOLOWER, TOUPPER, TRIM , SUBSTRINGOF
 	}
	
 
}
