/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter;

import java.util.List;

/**
 * Represents a function node. Currently supported functions are listed in {@link com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.FUNCTION Function}
 *
 */
public interface FunctionNode extends ExpressionNode {
	
   /**
    * Gets the name of the function.
    * 
    * @return A string representing the function name
    */
   public String getFunctionName();
   
   /**
    * Gets the number of parameters in the function.
    *
    *@return Number of parameters
    */
   public int getParameterCount();
   
   /**
    * Gets the list of filter expressions used in the function.
    * 
    * @return List of <code>ExpressionNode</code> objects
    */
   public List<ExpressionNode> getParameters();
    
}
