/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter;


/**
 * Represents a leaf node which has a literal value.
 *
 */
public interface LiteralNode extends ExpressionNode {
	
	   /**
	    * Sets the value in the literal node.
	    * 
	    * @param obj Represents the value to be set in the literal node
	    */
	   public void setValue(Object obj);
	   
	   /**
	    * Gets the value of the literal node.
	    * 
	    * * @param obj Represents the value of the literal node
	    */
	   public Object getValue( ); 
	}
