/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter;


public interface UnaryExpressionNode extends ExpressionNode {
	
	/**
	 * Gets the child node of the unary expression.
	 * 
	 * @return An <code>ExpressionNode</code> object representing the child node
	 */
	public ExpressionNode getChild();
	
	/**
	 * Gets the operator used in the unary expression.
	 * 
	 * @return A string representing the operator
	 */
	public String getOperator() ;
}
