/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import java.util.Arrays;
import java.util.List;

import com.sap.cloud.sdk.service.prov.api.filter.BinaryExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.NODE_KIND;

public class BinaryExpressionNodeImpl implements BinaryExpressionNode, FilterNodeInternal {
	private FilterNodeInternal firstChild;
	private FilterNodeInternal secondChild;
	private NodeInfoImpl nodeInfo;
	private boolean leafUnitNode = false;

	public BinaryExpressionNodeImpl(FilterNodeInternal firstChild, FilterNodeInternal secondChild,
			NodeInfoImpl nodeInfo) {
		this.firstChild = firstChild;
		this.secondChild = secondChild;
		this.nodeInfo = nodeInfo;

		leafUnitNode = getChildren().stream().filter(node -> {
			return ((node.getKind() == NODE_KIND.PROPERTY || node.getKind() == NODE_KIND.LITERAL) ? true : false);
		}).findAny().isPresent();

	}

	@Override
	public boolean isLeafUnit() {
		return leafUnitNode;
	}

	@Override
	public ExpressionNode getFirstChild() {
		return firstChild;
	}

	@Override
	public ExpressionNode getSecondChild() {
		return secondChild;
	}

	@Override
	public List<FilterNodeInternal> getChildren() {
		return Arrays.asList(firstChild, secondChild);
	}

	@Override
	public NODE_KIND getKind() {
		return NODE_KIND.BINARY;
	}

	@Override
	public String getOperator() {
		return nodeInfo.getNodeOperator();
	}

	@Override
	public boolean isCustomNode() {
		return nodeInfo.isCustomNode();
	}


	 
}
