/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import com.sap.cloud.sdk.service.prov.api.filter.Expression;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionBuilder;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.BINARY_OPERATOR;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.NODE_KIND;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.UNARY_OPERATOR;
import com.sap.cloud.sdk.service.prov.api.filter.exception.FilterOptionException;

/**
 * 
 * Provides methods for building binary expressions.
 *
 */
public class ExpressionBuilderImpl implements ExpressionBuilder {

	@Override
	public Expression createExpression(String path, BINARY_OPERATOR operator, Object value)
			throws FilterOptionException {

		switch(operator.name()){
		case  "EQ" :
		case  "NE" :
		case  "LT" :
		case  "GT" :
		case  "LE" :
		case  "GE" :
			break ;
		default: 
			throw new FilterOptionException("Only EQ, NE, LT, GT, LE, GE are supported");	
		}
		
		NodeInfoImpl literalNodeInfo = new NodeInfoImpl(NODE_KIND.LITERAL);
		literalNodeInfo.setCustomNode(true);
	
		
		FilterNodeInternal literalNode = new LiteralNodeImpl(value, literalNodeInfo);
		
		NodeInfoImpl propertyNodeInfo = new NodeInfoImpl("", NODE_KIND.PROPERTY);
		propertyNodeInfo.setCustomNode(true);
		
		FilterNodeInternal simpleMember = new PropertyNodeImpl(path,
				propertyNodeInfo);
		

		NodeInfoImpl binaryNodeInfo = new NodeInfoImpl(operator.name(), NODE_KIND.BINARY);
		binaryNodeInfo.setCustomNode(true);

		return new BinaryExpressionNodeImpl(literalNode, simpleMember,
				binaryNodeInfo);

	}

	@Override
	public Expression createExpression(Expression left, BINARY_OPERATOR operator, Expression right) throws FilterOptionException {
		
		switch(operator.name()){
		case  "AND"  :
		case  "OR"  :	
			break ;
		default: 
			throw new FilterOptionException("Only AND , OR operators supported");
		}
		
		NodeInfoImpl binaryNodeInfo = new NodeInfoImpl(operator.name(), NODE_KIND.BINARY);
		binaryNodeInfo.setCustomNode(true);
		
		Expression exp =  new BinaryExpressionNodeImpl((FilterNodeInternal) left, (FilterNodeInternal) right,
				binaryNodeInfo);
		
		return exp;
	}

	@Override
	public Expression not(Expression expression) {

		return new UnaryExpressionNodeImpl((FilterNodeInternal) expression,
				new NodeInfoImpl(UNARY_OPERATOR.NOT.name(), NODE_KIND.UNARY));
	}
	
	 

	@Override
	public Expression and(Expression left, Expression right) {
		return new BinaryExpressionNodeImpl((FilterNodeInternal) left, (FilterNodeInternal) right,
				new NodeInfoImpl(BINARY_OPERATOR.AND.name(), NODE_KIND.BINARY));
	}
	 	

}
