/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import java.util.List;
import java.util.stream.Collectors;

import com.sap.cloud.sdk.service.prov.api.filter.ExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.FunctionNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.NODE_KIND;

public class FunctionNodeImpl implements FunctionNode, FilterNodeInternal {
	private String functionName;
	private NodeInfoImpl nodeInfo;
	private List<FilterNodeInternal> parameters;
	private boolean leafUnitNode = false;

	public FunctionNodeImpl(String functionName, List<FilterNodeInternal> parameters, NodeInfoImpl nodeInfo) {
		this.functionName = functionName;
		this.parameters = parameters;
		this.nodeInfo = nodeInfo;

		leafUnitNode = getChildren().stream().filter(node -> {
			return ((node.getKind() == NODE_KIND.PROPERTY || node.getKind() == NODE_KIND.LITERAL) ? true
					: false);
		}).findAny().isPresent();
	}

	@Override
	public boolean isLeafUnit() {
		return leafUnitNode;
	}

	@Override
	public String getFunctionName() {
		return functionName;
	}

	@Override
	public int getParameterCount() {
		return parameters.size();
	}

	@Override
	public List<ExpressionNode> getParameters() {
		return parameters.stream().map(nodeInternal -> {
			return (ExpressionNode) nodeInternal;
		}).collect(Collectors.toList());
	}

	@Override
	public NODE_KIND getKind() {
		return nodeInfo.getNodeKind();
	}

	@Override
	public List<FilterNodeInternal> getChildren() {
		return parameters;
	}

	@Override
	public boolean isCustomNode() {
		
		return nodeInfo.isCustomNode();
	}

	@Override
	public String getOperator() {
		return nodeInfo.getNodeOperator();
	}

	 

}
